import java.awt.*;
import java.lang.*;
import java.util.Vector;
import iactivegraph.IGraph;
import iactivegraph.IGraphLine;
import iactivegraph.IGraphPoint;
import iactivegraph.IGraphFunction;
import iactivegraph.IGraphException;
import iactivegraph.IGraphRangeException;


public class GDuration extends java.applet.Applet implements Runnable,
		IGraphFunction {
    Thread		thread;
	IGraph		graph;

    public void init() {
		setLayout(new BorderLayout());
		try {
			// -200 - 400 is -20.0 - 40.0 and -20 - 1000 is -2.00 - 10.00
			graph = new IGraph(
				1996, 2006, 10, 1,
				0, 200, 20, 10,
				0, 2500, 20, 10,
				this);
		} catch (IGraphException e) {
			System.out.println("IGraph Exception encountered: "+e.getMessage());
			System.exit(0);
		} catch (Exception e) {
			System.out.println("Exception encountered: "+e.getMessage());
			System.exit(0);
		}
		add("Center", graph);

    }
    public boolean handleEvent(Event e) {
		if (e.id == Event.WINDOW_DESTROY) {
			System.exit(0);
		}
		return false;
    }
    
    public void start() {
		thread = new Thread(this);
		thread.start();
    }
    public void stop() {
		thread.stop();
    }
    public void run() {
	}

	//
	// These functions are needed to implement the IGraphFunction 
	// interface.
	//
	public void calculate(Vector lines, IGraphLine result) {
		int	i;
		if (lines.size() != 2) return;

		IGraphLine line1 = (IGraphLine)lines.elementAt(0);
		IGraphLine line2 = (IGraphLine)lines.elementAt(1);
		int n = line1.size();
		if (n > line2.size()) n = line2.size();
		float	rates[] = new float[n+1];
		int	x, y, vx, vy;
		rates[0] = (float)1.0;
		// Results are 1 based
		for (int j = 0; j < n; j++) {
			IGraphPoint	point1 = (IGraphPoint)line1.elementAt(j);
			IGraphPoint	point2 = (IGraphPoint)line2.elementAt(j);
			vy = point1.getValY() - point2.getValY();
			// Get the cum rate. Divide by the scale and by 100.
			rates[j+1] = rates[j]*(float)(1.0+vy/1000.0);
//System.out.println("rate["+j+"]: "+rates[j]);
		}
		// Iterate through all the points
		for (int j = 0; j < n; j++) {
			// Go through all the lines
			IGraphPoint	point1 = (IGraphPoint)line1.elementAt(j);
			IGraphPoint	point2 = (IGraphPoint)line2.elementAt(j);
			x = (point1.x + point2.x*2)/3;
			vx = (point1.getValX() + point2.getValX()*2)/3;

			//int vy1 = point1.getValY();
			//vy = (point1.getValY() + point2.getValY()*2)/3;
			vy = (int) (rates[j+1]*(float)1000.0);
//System.out.println("val: "+vy);
			y = graph.rValToYPos(vy);
			result.addPoint(x, y, vx, vy);
		}
	}
	// This function creates the lines in the graph
	public void initGraph(IGraph graph) {
		try {
			// Create the lines
			// Return line
			graph.addLine(50, 50, 10, Color.blue);
			// Inflation line
			graph.addLine(20, 20, 10, Color.red);
			// Initialize the annotate flag
			graph.setAnnotate(false);
		} catch (IGraphRangeException e) {
			System.out.println("IGraph Exception encountered: "+e.getMessage());
			System.out.println("From: "+e.from+" to: "+e.to+" val: "+e.val);
			System.exit(0);
		} catch (IGraphException e) {
			System.out.println("IGraph Exception encountered: "+e.getMessage());
			System.exit(0);
		} catch (Exception e) {
			System.out.println("Exception encountered: "+e.getMessage());
			System.exit(0);
		}
	}
}
