package iactivegraph;

import java.awt.*;
import java.lang.*;
import java.util.Vector;
import iactivegraph.IGraphFunction;
import iactivegraph.IGraphLine;
import iactivegraph.IGraphPoint;
import iactivegraph.IGraphException;
import iactivegraph.IGraphRangeException;

public class IGraphAverageFunction implements IGraphFunction {
	int		fromy, toy, scaley;
	public IGraphAverageFunction(int fy, int ty, int scy) {
		fromy = fy;
		toy = ty;
		scaley = scy;
	}
	public void calculate(Vector lines, IGraphLine result) {
		int	count = lines.size();
		// Iterate through all the points until one of the lines has no points
		boolean	done = false;
		for (int j = 0; !done; j++) {
			// Go through all the lines
			int	x = 0, y = 0;
			int	vx = 0, vy = 0;
			for (int i = 0; i < count; i++) {
				IGraphLine line = (IGraphLine)lines.elementAt(i);
				// if one of the lines is short, stop here.
				if (j >= line.size()) {
					done = true;
					break;
				}
				IGraphPoint	point = (IGraphPoint)line.elementAt(j);
				x += point.x;
				y += point.y;
				vx += point.getValX();
				vy += point.getValY();
			}
			if (!done) result.addPoint(x/count, y/count, vx/count, vy/count);
		}
	}
	public void initGraph(IGraph graph) {
		if (fromy != 0 || toy != 0) {
			try {
				graph.addLine(fromy, toy, scaley, Color.red);
				graph.addLine(toy, fromy, scaley, Color.blue);
			} catch (IGraphRangeException e) {
				System.out.println("IGraph Exception encountered: "+e.getMessage());
				System.out.println("From: "+e.from+" to: "+e.to+" val: "+e.val);
				System.exit(0);
			} catch (IGraphException e) {
				System.out.println("IGraph Exception encountered: "+e.getMessage());
				System.exit(0);
			} catch (Exception e) {
				System.out.println("Exception encountered: "+e.getMessage());
				System.exit(0);
			}
		}
	}
}
