package iactivegraph;

import java.awt.*;
import java.lang.*;
import java.util.Vector;
import iactivegraph.IGraphFunction;
import iactivegraph.IGraphAverageFunction;
import iactivegraph.IGraphPoint;
import iactivegraph.IGraph;

public class IGraphLine extends Vector {
	Canvas	canvas;
	Color	color;	// Color for points (null for none).
	boolean	annotate;
	public IGraphLine(Canvas c) {
		this(c, null, false);
	}
	public IGraphLine(Canvas c, boolean an) {
		this(c, null, an);
	}
	public IGraphLine(Canvas c, Color col) {
		this(c, col, false);
	}
	public IGraphLine(Canvas c, Color col, boolean an) {
		color = col;
		canvas = c;
		annotate = an;
	}
	public	void addPoint(int x, int y, int valx, int valy) {
		this.addElement(new IGraphPoint(x, y, valx, valy));
	}
	public	void paint(Graphics g, IGraph graph) {
		IGraphPoint	ppoint = null;
		for (int i = 0; i < size(); i++) {
			IGraphPoint point = (IGraphPoint)elementAt(i);
			int x = point.x;
			int y = point.y;
			if (ppoint != null) {
				int px = ppoint.x; int py = ppoint.y;
				g.setColor(Color.black);
				g.drawLine(px, py, x, y);
				// Print the previous now to overlay the line
				if (color != null) {
					g.setColor(color);
					ppoint.paint(g);
				} else {
					// Draw a double line if there are no dots
					g.drawLine(px, py-1, x, y-1);
					g.drawLine(px+1, py, x+1, y);
				}
				if (annotate)
					ppoint.annotate(g, graph.rValToValString(ppoint.getValY()));
			}
			ppoint = point;
		}
		// Print the last point
		if (ppoint != null) {
			if (color != null) {
				g.setColor(color);
				ppoint.paint(g);
			}
			if (annotate) {
				ppoint.annotate(g, graph.rValToValString(ppoint.getValY()));
			}
		}
	}
	public IGraphPoint found(int x, int y) {
		if (color == null) return null;
		for (int i = 0; i < size(); i++) {
			IGraphPoint	point = (IGraphPoint)elementAt(i);
			if (point.inside(x,y)) return point;
		}
	    return null;
	}
}
