package iactivegraph;

import java.awt.*;
import java.lang.*;

public class IGraphPoint extends Point {
	Rectangle	rect;		// Rectangle to draw
	Rectangle	hitrect;	// Rectangle for sensing hits
	int			valx, valy;	// Actual values
	final int	dim = 5;
	final int	rad = dim/2;
	final int	hitdim = dim*3;
	public	IGraphPoint(int x, int y, int vx, int vy) {
		super(x, y);
		valx = vx; valy = vy;
		rect = new Rectangle(x-rad, y-rad, dim, dim);
		hitrect = new Rectangle(x-rad-dim, y-rad-dim, hitdim, hitdim);
	}
	public	void paint(Graphics g) {
		g.fill3DRect(rect.x, rect.y, rect.width, rect.height, true);
	}
	/** Annotate the point with s */
	public	void annotate(Graphics g, String s) {
		g.setColor(Color.red);
		g.drawString(s, rect.x, rect.y);
	}
	/** Default, annotate with the y value */
	public	void annotate(Graphics g) {
		annotate(g, ""+valy);
	}
	public	boolean inside(int x, int y) {
		return hitrect.inside(x, y);
	}
	public	void moveY(int y, int vy) {
		this.y = y;
		rect.y = y-rad;
		hitrect.y = y-rad-dim;
		valy = vy;
	}
	public int getValX() {
		return valx;
	}
	public int getValY() {
		return valy;
	}
}
