#!/usr/bin/perl
use strict;
BEGIN {
	unshift @INC, "/home/bpollak/public_html/cgi-bin/lib/perl5/";
	unshift @INC, "/home/bpollak/perl5/lib/perl5/";
	#unshift @INC, "/home/bpollak/public_html/cgi-bin/mb";
}

use XML::DOM;
use Finance::MtGox;
use JSON;
use strict;

my $bitstamp;
if (open(BTCS, "curl 'https://www.bitstamp.net/api/ticker/' 2> /dev/null|")) {
	my $json = JSON->new->allow_nonref;
	while (<BTCS>) {
		chomp;
		my $perl_scalar = $json->decode( $_ );
		$bitstamp = $perl_scalar->{'last'};

	}
}
#my $j = "\{\"high\"\:\ \"673.01\"\,\ \"last\"\:\ \"614.00\"\,\ \"timestamp\"\:\ \"1392580309\"\,\ \"bid\"\:\ \"612.63\"\,\ \"volume\"\:\ \"24302.97603865\"\,\ \"low\"\:\ \"590.01\"\,\ \"ask\"\:\ \"614.00\"\}";

#$json_text   = $json->encode( $perl_scalar );

#my $pretty_printed = $json->pretty->encode( $perl_scalar ); # pretty-printing
#print $pretty_printed;

my $mtgox = Finance::MtGox->new({
key => 'c7987165-3ae5-4316-afa2-d4719736d5ea',
secret => '5me536MgwC+gpuwM9G9XvxRFPYnwZSg6peoE+W8hDxDGbevnbJUDsjHim4tcgi1k6S+wP3XmNDx8q2hoE+8L8w==',
		    });


my $btc = $mtgox->market_price;


print <<EOS;
Content-Type: text/plain

EOS

my (@date)=localtime;
$date[5]+=1900;$date[4]++;
my $nowdate=sprintf("%0.4d-%0.2d-%0.2d",$date[5],$date[4]++, $date[3]);
my $nowtime=sprintf("%0.2d:%0.2d:%0.2d", $date[2],$date[1],$date[0]);

my $xml = "<ufcalc>\n";
if ($bitstamp) {
	$bitstamp = 1.0 / $bitstamp;
	$xml .= "    <curr sym=\"BitStamp\" val=\"$bitstamp\" date=\"$nowdate\" time=\"$nowtime\"/>\n" ;
}
if ($btc) {
	$btc = 1.0 / $btc;
	$xml .= "    <curr sym=\"MtGox\" val=\"$btc\" date=\"$nowdate\" time=\"$nowtime\"/>\n" ;
}
$xml .= "    <curr sym=\"USD\" val=\"1.0\" date=\"$nowdate\" time=\"$nowtime\"/>\n";
my @currencies = qw(GCG14.CMX CLF EUR JPY GBP CLP CAD CHF AUD ARS PEN MXN ILS BOB COP BRL ECS CNY);
my $currq = "USD" . join ("=X,USD", sort(@currencies)) . "=X";

if (!open(YF, "curl 'http://download.finance.yahoo.com/d/quotes.csv?s=$currq&f=sl1d1t1c1ohgv' 2> /dev/null|")) {
	print "<error/>\n";
	exit;
}
while (<YF>) {
	chomp;
	s/"//g;
	my @f = split /,/;
	my ($sym, $val, $date, $time) = @f;
	next if ($val eq "0.0" || $val eq "0.00");
	#print "sym: $sym val: $val \n";
	$sym =~ s/USD//;
	$sym =~ s/=X//;
	my ($m,$d,$y) = split(/\//, $date);
	my $date = sprintf("%s-%2.2d-%2.2d", $y, $m, $d);
	$xml .= "    <curr sym=\"$sym\" val=\"$val\" date=\"$date\" time=\"$time\"/>\n";
}
if (!open(YF, "curl 'http://download.finance.yahoo.com/d/quotes.csv?s=GCG14.CMX&f=sl1d1t1c1ohgv' 2> /dev/null|")) {
	print "<error/>\n";
	exit;
}
while (<YF>) {
	chomp;
	s/"//g;
	my @f = split /,/;
	my ($sym, $val, $date, $time) = @f;
	next if ($val eq "0.0" || $val eq "0.00");
	#print "sym: $sym val: $val \n";
	$sym =~ s/USD//;
	$sym =~ s/=X//;
	my ($m,$d,$y) = split(/\//, $date);
	my $date = sprintf("%s-%2.2d-%2.2d", $y, $m, $d);
	$xml .= "    <curr sym=\"Gold\" val=\"$val\" date=\"$date\" time=\"$time\"/>\n";
}
#$xml .= getUF(2010);

$xml .= "</ufcalc>\n";
print "$xml\n";
