#!/usr/bin/perl
use strict;

print <<EOS;
Content-Type: text/plain

EOS
my @currencies = qw(EUR JPY GBP CLP CAD CHF AUD ARS PEN MXN ILS BOB COP BRL ECS);
my $currq = "USD" . join ("=X,USD", sort(@currencies)) . "=X";

if (!open(YF, "curl 'http://download.finance.yahoo.com/d/quotes.csv?s=$currq&f=sl1d1t1c1ohgv' 2> /dev/null|")) {
	print "<error/>\n";
	exit;
}

my (@date)=localtime;
$date[5]+=1900;$date[4]++;
my $nowdate=sprintf("%0.4d-%0.2d-%0.2d",$date[5],$date[4]++, $date[3]);
my $nowtime=sprintf("%0.2d:%0.2d:%0.2d", $date[2],$date[1],$date[0]);

my $xml = "<ufcalc>\n";
$xml .= "    <curr sym=\"USD\" val=\"1.0\" date=\"$nowdate\" time=\"$nowtime\"/>\n";
while (<YF>) {
	chomp;
	s/"//g;
	my @f = split /,/;
	my ($sym, $val, $date, $time) = @f;
	next if ($val eq "0.0" || $val eq "0.00");
	#print "sym: $sym val: $val \n";
	$sym =~ s/USD//;
	$sym =~ s/=X//;
	my ($m,$d,$y) = split(/\//, $date);
	my $date = sprintf("%s-%2.2d-%2.2d", $y, $m, $d);
	$xml .= "    <curr sym=\"$sym\" val=\"$val\" date=\"$date\" time=\"$time\"/>\n";
}
$xml .= getUF();

$xml .= "</ufcalc>\n";
print "$xml\n";

sub getUF {
	my ($debug) = @_;
	my $url = "http://si2.bcentral.cl/Basededatoseconomicos/951_455.asp?s=UF";
	if (!open(UF, "curl 'http://si2.bcentral.cl/Basededatoseconomicos/951_455.asp?s=UF&inSesionAno=2010' 2> /dev/null|")) {
		print "<error/>\n";
		exit;
	}

	my $totdays = 12 * 31;
	my @allvals;
	my @alldates;
	for (my $i = 0; $i < $totdays; $i++) {
		push @allvals, 0.0;
		push @alldates, "";
	}

	my $year = 2010;
	while (<UF>) {
		next unless(/script language=javascript>document.formASP.inSesionAno.value='([0-9]*)/);
		$year = $1;
		chomp;
		my $line = $_;
		my $day = 1;
		foreach my $row (split /<tr[^>]*>/,$line) {
			next unless($row =~ /<font class=detalle>([0-9]+)/);
			next if ($row =~ /script language=javascript>document.formASP.inSesionAno.value/);
			$row =~ s/<td align=center><font class=detalle>//;
			$row =~ s/<\/td><\/tr>//;
			$row =~ s/<\/font>//;
			#$row =~ s/-//g;
			$row =~ s/\.//g;
			$row =~ s/,/./g;
			my @vals = split(/<\/td><td align=right>/,$row);
			#print join("+", @vals) . "\n";
			for (my $month = 1; $month <= 12; $month++) {
				my $date = sprintf("%s-%2.2d-%2.2d", $year, $month, $vals[0]);
				my $indx = 31 * ($month - 1) + $day - 1;
				$alldates[$indx] = $date;
				my $val = ($vals[$month] =~ /-/) ? -1 : $vals[$month];
				$allvals[$indx] = $val;

				#printf("%d %s-%2.2d-%2.2d %f\n", $indx, $year, $month, $vals[0], $vals[$month]);
			}
			$day++;
			#print "($1)   $row\n";
		}
	}
	my $nextval = 0.0;
	for (my $i = $totdays-1; $i >= 0; $i--) {
		if (!$allvals[$i]) {
			$allvals[$i] = $nextval;
		}
		$nextval = $allvals[$i];
	}

	for (my $i = 0; $i < $totdays; $i++) {
		print $i . "  " . $alldates[$i] . " " . $allvals[$i] . "\n" if ($debug);
	}
		my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst) = localtime(time);
		$year += 1900;
		my $bdate = $year - 2010  + $mon*31 + $mday-1;
		my $time = "$hour:$min";
		my $date =$alldates[$bdate];
		my $val = $allvals[$bdate];
		my $xml=<<EOS;
    <curr sym="UF" val="$val" date="$date" time="$time"/>
EOS
		for (my $i = $bdate; $i < scalar(@allvals); $i++) {
			if ($allvals[$i] > 0) {
				print $alldates[$i] . "   " .$allvals[$i] . "\n" if ($debug);
			$xml.=<<EOS;
    <uf val="$allvals[$i]" date="$alldates[$i]"/>
EOS
			}
			last if ($allvals[$i] eq "0");
		}
		return $xml;
}
