#!/usr/local/bin/perl

# Defaults:
#require strict vars;
sub LockFile {
	my ($counterfile) = @_;
	#
	#  Establish a lock for the counter file
	#
	my $count = 0;
	while (-f "$counterfile.lock") {
		sleep 1;
		if ($count++ > 5) {
			unlink ("$counterfile.lock");
		}
	}
	open (LOCK, ">$counterfile.lock");
}
sub UnlockFile {
	my ($counterfile) = @_;
	#
	#  Free the lock on this counter
	#
	close (LOCK);
	unlink ("$counterfile.lock");
}
sub WriteCounter {
	my ($counterfile, $countervalue) = @_;
	#
	#  Write the updated value back to the file
	#
	my $len = length ($countervalue);
	if (open (COUNTERFILE, ">$counterfile") != 0) {
		printf COUNTERFILE "%0${len}u\n", $countervalue;
		$countervalue = sprintf ("%0${len}u", $countervalue);
		close (COUNTERFILE);
	}
	#
	#	Write host information
	#
	if (open (INFOFILE, ">>$counterfile.info") != 0) {
		my $date=`date`;
		printf INFOFILE "Visit at: %s", $date;
		printf INFOFILE "REMOTE_HOST:       %s\n",$ENV{"REMOTE_HOST"};
		printf INFOFILE "REMOTE_ADDR:       %s\n",$ENV{"REMOTE_ADDR"};
		close (INFOFILE);
	}
}
sub BumpCounterValue {
	my ($counterfile) = @_;
	LockFile($counterfile);

	#
	#  Read and increment the counter file
	#
	my $countervalue = 1;
	if (open (COUNTERFILE, "<$counterfile") == 0) {
		$countervalue = 1;
	} else {
		$countervalue = <COUNTERFILE>;
		close (COUNTERFILE);
		$countervalue++;
	}
	WriteCounter($counterfile, $countervalue);
	UnlockFile($counterfile);
}

sub InitCounterValue {
	my ($counterfile) = @_;
	LockFile($counterfile);

	my $countervalue = 0;
	WriteCounter($counterfile, $countervalue);
	UnlockFile($counterfile);
}

1;
