#!/usr/bin/perl 
BEGIN {
	unshift @INC, "/home/bpollak/perl5/lib/perl5";
}

use XML::DOM;
use strict;

print <<EOS;
Content-Type: text/html

<head><title>Rationally Speaking Downloads</title></head>
<style type="text/css">h1 {text-align:CENTER; font-size:20pt;} h2 {width:95%; padding:3pt; font-family:ARIAL; font-weight:bold; border:none; font-size:12pt; color:#FFFFFF; background-color:#000000;} body {color:#000000; font-family:Helvetica,sans-serif;} td.alt2 {background-color:#EEEEEE;} p {color:#000000; font-family:Helvetica,sans-serif;} .smallfont {font-size:8pt;} th.total {background-color:#CCCCCC;} .fineprint {font-size:7pt;} td {font-family:Helvetica;} th {background-color:#9999CC;} </style></head><body><h1>Rationally Speaking Downloads Starting from 3/10/2010</h1>
</body>
<table cellpadding="5" border="0">
<tr>
<th>Rank
<th>Episode
<th>Downloads
<th>%  of Total
<th>As of
<th>Title
<th>Pub date
</tr>
EOS


my $parser = new XML::DOM::Parser;

if (!open(YF, "curl 'http://nycskeptics.org/storage/feeds/rs.xml' 2> /dev/null|")) {
	print "<error/>\n";
	exit;
}
my $xml;
while (<YF>) {
	$xml .= $_;
}
my $doc = $parser->parse($xml);

# print all HREF attributes of all CODEBASE elements
my $items = $doc->getElementsByTagName ("item");
my %titles;
my %pubDates;
foreach my $item (@$items) {
	my $title = $item->getElementsByTagName ("title")->[0]->getFirstChild()->getData();
	my $pubDate = $item->getElementsByTagName ("pubDate")->[0]->getFirstChild()->getData();
	my $enclosure = $item->getElementsByTagName ("enclosure")->[0]->getAttribute("url");;
	$enclosure =~ /.*(rs\d*)\.mp3/;
	my $rsnum = $1;
	#print $title . " - $rsnum - " . $enclosure ."\n";
	$titles{$rsnum} = $title;
	$pubDate =~ s/ \d+:.*$//;
	$pubDate =~ s/Sun, //;
	$pubDates{$rsnum} = $pubDate;
}


if (!open(YF, "curl -u skepticmedia:ElMedi0! http://skepticmedia.org/stats/REQUEST.html 2> /dev/null|")) {
	print "<error/>: $!\n";
	exit;
}

while (<YF>) {
	my @rows = split /<tr>/;
	my $i = 0;
	for my $row (@rows) {
	#print "************** $row\n";
		next unless ($row =~ /skepticmedia.org\/rsaudio\/rs[0-9]*\.mp3<\/b>/);
		my $alt = $i % 2 + 1;
		$row =~ s/alt[12]/alt${alt}/g;
		$row =~ s/skepticmedia.org\/rsaudio\///g;
		$row =~ s/<b>//g;
		$row =~ s/<\/b>//g;
		$row =~ /^(.*>)(rs\d*)(\.mp3.*)<\/td><\/tr>/;
		my $rsnum = $2;
		my $title = $titles{$rsnum};
		my $pubDate = $pubDates{$rsnum};
		$row =~ s/^(.*>)(rs\d*)\.mp3(.*)<\/td><\/tr>/$1<a href="\/\/skepticmedia.org\/rsaudio\/$2.mp3">$2.mp3$3<\/a><\/td><td><a href=\"http:\/\/www.rationallyspeakingpodcast.org\/$2\">${title}<\/a><\/td><td>${pubDate}<\/td><\/tr>/g;
		print "$row\n";
		$i++;
	}

	chomp;
}

print <<EOS;
</table>
</body>
EOS
=pod=cut
