#!/usr/local/bin/perl
use XML::DOM;
use strict;

my $parser = new XML::DOM::Parser;

if (!open(YF, "curl 'http://nycskeptics.org/storage/feeds/rs.xml' 2> /dev/null|")) {
	print "<error/>\n";
	exit;
}
my $xml;
while (<YF>) {
	$xml .= $_;
}
my $doc = $parser->parse($xml);

# print all HREF attributes of all CODEBASE elements
my $items = $doc->getElementsByTagName ("item");
foreach my $item (@$items) {
	my $title = $item->getElementsByTagName ("title")->[0];
	my $enclosure = $item->getElementsByTagName ("enclosure")->[0]->getAttribute("url");;
	$enclosure =~ /.*rs(\d*)\.mp3/;
	my $episode = $1;
	print $title->getFirstChild()->getData() . " - $episode - " . $enclosure ."\n";
}
