/*
 * Decompiled with CFR 0.152.
 */
package org.jfree.date.junit;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import junit.framework.Assert;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.jfree.date.SerialDate;
import org.jfree.date.SpreadsheetDate;

public class SpreadsheetDateTests
extends TestCase {
    private SerialDate jan1Y1900;
    private SerialDate s2;
    static /* synthetic */ Class class$org$jfree$date$junit$SpreadsheetDateTests;

    public SpreadsheetDateTests(String name) {
        super(name);
    }

    static /* synthetic */ Class class$(String class$) {
        try {
            return Class.forName(class$);
        }
        catch (ClassNotFoundException forName) {
            throw new NoClassDefFoundError(forName.getMessage());
        }
    }

    protected void setUp() {
        this.jan1Y1900 = new SpreadsheetDate(1, 1, 1900);
        this.s2 = new SpreadsheetDate(2);
    }

    public static Test suite() {
        return new TestSuite(class$org$jfree$date$junit$SpreadsheetDateTests != null ? class$org$jfree$date$junit$SpreadsheetDateTests : (class$org$jfree$date$junit$SpreadsheetDateTests = SpreadsheetDateTests.class$("org.jfree.date.junit.SpreadsheetDateTests")));
    }

    public void test01Feb2000ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(1, 2, 2000);
        Assert.assertEquals((int)36557, (int)d.toSerial());
    }

    public void test01Jan1900ToSerial() {
        int serial = this.jan1Y1900.toSerial();
        Assert.assertEquals((int)2, (int)serial);
    }

    public void test01Jan2000ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(1, 1, 2000);
        Assert.assertEquals((int)36526, (int)d.toSerial());
    }

    public void test01Mar1900ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(1, 3, 1900);
        Assert.assertEquals((int)61, (int)d.toSerial());
    }

    public void test12Nov2001GetDayOfWeek() {
        SpreadsheetDate nov12Y2001 = new SpreadsheetDate(12, 11, 2001);
        int dayOfWeek = ((SerialDate)nov12Y2001).getDayOfWeek();
        Assert.assertEquals((int)2, (int)dayOfWeek);
    }

    public void test1Jan1900GetDayOfWeek() {
        int dayOfWeek = this.jan1Y1900.getDayOfWeek();
        Assert.assertEquals((int)2, (int)dayOfWeek);
    }

    public void test1mar2000ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(1, 3, 2000);
        Assert.assertEquals((int)36586, (int)d.toSerial());
    }

    public void test28Feb1900ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(28, 2, 1900);
        Assert.assertEquals((int)60, (int)d.toSerial());
    }

    public void test28Feb2000ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(28, 2, 2000);
        Assert.assertEquals((int)36584, (int)d.toSerial());
    }

    public void test29feb2000ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(29, 2, 2000);
        Assert.assertEquals((int)36585, (int)d.toSerial());
    }

    public void test31Dec1999ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(31, 12, 1999);
        Assert.assertEquals((int)36525, (int)d.toSerial());
    }

    public void test31Jan2000ToSerial() {
        SpreadsheetDate d = new SpreadsheetDate(31, 1, 2000);
        Assert.assertEquals((int)36556, (int)d.toSerial());
    }

    public void test36584() {
        SpreadsheetDate d = new SpreadsheetDate(36584);
        Assert.assertEquals((int)28, (int)d.getDayOfMonth());
        Assert.assertEquals((int)2, (int)d.getMonth());
        Assert.assertEquals((int)2000, (int)d.getYYYY());
    }

    public void test36585() {
        SpreadsheetDate d = new SpreadsheetDate(36585);
        Assert.assertEquals((int)29, (int)d.getDayOfMonth());
        Assert.assertEquals((int)2, (int)d.getMonth());
        Assert.assertEquals((int)2000, (int)d.getYYYY());
    }

    public void test36586() {
        SpreadsheetDate d = new SpreadsheetDate(36586);
        Assert.assertEquals((int)1, (int)d.getDayOfMonth());
        Assert.assertEquals((int)3, (int)d.getMonth());
        Assert.assertEquals((int)2000, (int)d.getYYYY());
    }

    public void test37986() {
        SpreadsheetDate d = new SpreadsheetDate(37986);
        Assert.assertEquals((int)31, (int)d.getDayOfMonth());
        Assert.assertEquals((int)12, (int)d.getMonth());
        Assert.assertEquals((int)2003, (int)d.getYYYY());
    }

    public void test37987() {
        SpreadsheetDate d = new SpreadsheetDate(37987);
        Assert.assertEquals((int)1, (int)d.getDayOfMonth());
        Assert.assertEquals((int)1, (int)d.getMonth());
        Assert.assertEquals((int)2004, (int)d.getYYYY());
    }

    public void test38352() {
        SpreadsheetDate d = new SpreadsheetDate(38352);
        Assert.assertEquals((int)31, (int)d.getDayOfMonth());
        Assert.assertEquals((int)12, (int)d.getMonth());
        Assert.assertEquals((int)2004, (int)d.getYYYY());
    }

    public void test38353() {
        SpreadsheetDate d = new SpreadsheetDate(38353);
        Assert.assertEquals((int)1, (int)d.getDayOfMonth());
        Assert.assertEquals((int)1, (int)d.getMonth());
        Assert.assertEquals((int)2005, (int)d.getYYYY());
    }

    public void testS2GetDayOfMonth() {
        int dayOfMonth = this.s2.getDayOfMonth();
        Assert.assertEquals((int)1, (int)dayOfMonth);
    }

    public void testS2GetMonth() {
        int month = this.s2.getMonth();
        Assert.assertEquals((int)1, (int)month);
    }

    public void testS2GetYYYY() {
        int year = this.s2.getYYYY();
        Assert.assertEquals((int)1900, (int)year);
    }

    public void testSerialization() {
        SpreadsheetDate d1 = new SpreadsheetDate(15, 4, 2000);
        SpreadsheetDate d2 = null;
        try {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(buffer);
            out.writeObject(d1);
            out.close();
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(buffer.toByteArray()));
            d2 = (SpreadsheetDate)in.readObject();
            in.close();
        }
        catch (Exception e) {
            System.out.println(e.toString());
        }
        Assert.assertEquals((Object)d1, d2);
    }
}

