/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYBoxAndWhiskerRenderer;
import org.jfree.data.statistics.BoxAndWhiskerCalculator;
import org.jfree.data.statistics.BoxAndWhiskerXYDataset;
import org.jfree.data.statistics.DefaultBoxAndWhiskerXYDataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class BoxAndWhiskerChartDemo2
extends ApplicationFrame {
    public BoxAndWhiskerChartDemo2(String string) {
        super(string);
        JPanel jPanel = BoxAndWhiskerChartDemo2.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static BoxAndWhiskerXYDataset createDataset() {
        DefaultBoxAndWhiskerXYDataset defaultBoxAndWhiskerXYDataset = new DefaultBoxAndWhiskerXYDataset((Comparable)((Object)"Series Name"));
        RegularTimePeriod regularTimePeriod = new Day();
        for (int i = 0; i < 10; ++i) {
            List list = BoxAndWhiskerChartDemo2.createValueList(0.0, 20.0, 20);
            defaultBoxAndWhiskerXYDataset.add(regularTimePeriod.getStart(), BoxAndWhiskerCalculator.calculateBoxAndWhiskerStatistics(list));
            regularTimePeriod = ((RegularTimePeriod)regularTimePeriod).next();
        }
        return defaultBoxAndWhiskerXYDataset;
    }

    private static List createValueList(double d, double d2, int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>();
        for (int i = 0; i < n; ++i) {
            double d3 = d + Math.random() * (d2 - d);
            arrayList.add(new Double(d3));
        }
        return arrayList;
    }

    private static JFreeChart createChart(BoxAndWhiskerXYDataset boxAndWhiskerXYDataset) {
        DateAxis dateAxis = new DateAxis("Day");
        NumberAxis numberAxis = new NumberAxis("Value");
        XYBoxAndWhiskerRenderer xYBoxAndWhiskerRenderer = new XYBoxAndWhiskerRenderer();
        XYPlot xYPlot = new XYPlot(boxAndWhiskerXYDataset, dateAxis, numberAxis, xYBoxAndWhiskerRenderer);
        JFreeChart jFreeChart = new JFreeChart("Box-and-Whisker Chart Demo 2", xYPlot);
        jFreeChart.setBackgroundPaint(Color.white);
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setDomainGridlinesVisible(true);
        xYPlot.setRangeGridlinePaint(Color.white);
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = BoxAndWhiskerChartDemo2.createChart(BoxAndWhiskerChartDemo2.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        BoxAndWhiskerChartDemo2 boxAndWhiskerChartDemo2 = new BoxAndWhiskerChartDemo2("Box-and-Whisker Chart Demo 2");
        boxAndWhiskerChartDemo2.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)boxAndWhiskerChartDemo2));
        boxAndWhiskerChartDemo2.setVisible(true);
    }
}

