/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CompassFormat;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYAreaRenderer;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class CompassFormatDemo1
extends ApplicationFrame {
    static /* synthetic */ Class class$org$jfree$data$time$Minute;

    public CompassFormatDemo1(String string) {
        super(string);
        JFreeChart jFreeChart = CompassFormatDemo1.createChart();
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private static XYDataset createDirectionDataset(int n) {
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        TimeSeries timeSeries = new TimeSeries("Wind Direction", class$org$jfree$data$time$Minute == null ? (class$org$jfree$data$time$Minute = CompassFormatDemo1.class$("org.jfree.data.time.Minute")) : class$org$jfree$data$time$Minute);
        RegularTimePeriod regularTimePeriod = new Minute();
        double d = 180.0;
        for (int i = 0; i < n; ++i) {
            timeSeries.add(regularTimePeriod, d);
            regularTimePeriod = ((RegularTimePeriod)regularTimePeriod).next();
            d += (Math.random() - 0.5) * 15.0;
            if (d < 0.0) {
                d += 360.0;
                continue;
            }
            if (!(d > 360.0)) continue;
            d -= 360.0;
        }
        timeSeriesCollection.addSeries(timeSeries);
        return timeSeriesCollection;
    }

    private static XYDataset createForceDataset(int n) {
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection();
        TimeSeries timeSeries = new TimeSeries("Wind Force", class$org$jfree$data$time$Minute == null ? (class$org$jfree$data$time$Minute = CompassFormatDemo1.class$("org.jfree.data.time.Minute")) : class$org$jfree$data$time$Minute);
        RegularTimePeriod regularTimePeriod = new Minute();
        double d = 3.0;
        for (int i = 0; i < n; ++i) {
            timeSeries.add(regularTimePeriod, d);
            regularTimePeriod = ((RegularTimePeriod)regularTimePeriod).next();
            d = Math.max(0.5, d + (Math.random() - 0.5) * 0.5);
        }
        timeSeriesCollection.addSeries(timeSeries);
        return timeSeriesCollection;
    }

    private static JFreeChart createChart() {
        XYDataset xYDataset = CompassFormatDemo1.createDirectionDataset(600);
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Time", "Date", "Direction", xYDataset, true, true, false);
        XYPlot xYPlot = jFreeChart.getXYPlot();
        xYPlot.getDomainAxis().setLowerMargin(0.0);
        xYPlot.getDomainAxis().setUpperMargin(0.0);
        NumberAxis numberAxis = (NumberAxis)xYPlot.getRangeAxis();
        numberAxis.setAutoRangeIncludesZero(false);
        TickUnits tickUnits = new TickUnits();
        tickUnits.add(new NumberTickUnit(180.0, new CompassFormat()));
        tickUnits.add(new NumberTickUnit(90.0, new CompassFormat()));
        tickUnits.add(new NumberTickUnit(45.0, new CompassFormat()));
        tickUnits.add(new NumberTickUnit(22.5, new CompassFormat()));
        numberAxis.setStandardTickUnits(tickUnits);
        xYPlot.setRangeAxis(numberAxis);
        XYAreaRenderer xYAreaRenderer = new XYAreaRenderer();
        NumberAxis numberAxis2 = new NumberAxis("Force");
        numberAxis2.setRange(0.0, 12.0);
        xYAreaRenderer.setSeriesPaint(0, new Color(0, 0, 255, 128));
        xYPlot.setDataset(1, CompassFormatDemo1.createForceDataset(600));
        xYPlot.setRenderer(1, xYAreaRenderer);
        xYPlot.setRangeAxis(1, numberAxis2);
        xYPlot.mapDatasetToRangeAxis(1, 1);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = CompassFormatDemo1.createChart();
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        CompassFormatDemo1 compassFormatDemo1 = new CompassFormatDemo1("Compass Format Demo");
        compassFormatDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)compassFormatDemo1));
        compassFormatDemo1.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

