/*
 * Decompiled with CFR 0.152.
 */
package demo;

import demo.GanttRenderer2;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.geom.Rectangle2D;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.entity.CategoryItemEntity;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRendererState;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.data.gantt.GanttCategoryDataset;
import org.jfree.data.gantt.Task;
import org.jfree.data.gantt.TaskSeries;
import org.jfree.data.gantt.TaskSeriesCollection;
import org.jfree.data.time.SimpleTimePeriod;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;

public class GanttDemo3
extends ApplicationFrame {
    public GanttDemo3(String string) {
        super(string);
        JPanel jPanel = GanttDemo3.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    public static IntervalCategoryDataset createDataset() {
        TaskSeries taskSeries = new TaskSeries("1");
        taskSeries.add(new Task("Contrakt 1", new SimpleTimePeriod(GanttDemo3.date(1, 0, 2005), GanttDemo3.date(31, 5, 2005))));
        TaskSeries taskSeries2 = new TaskSeries("2");
        taskSeries2.add(new Task("Contrakt 1", new SimpleTimePeriod(GanttDemo3.date(1, 6, 2005), GanttDemo3.date(1, 1, 2006))));
        TaskSeries taskSeries3 = new TaskSeries("3");
        taskSeries3.add(new Task("Contrakt 2", new SimpleTimePeriod(GanttDemo3.date(1, 0, 2005), GanttDemo3.date(1, 1, 2006))));
        TaskSeries taskSeries4 = new TaskSeries("4");
        taskSeries4.add(new Task("Contrakt 3", new SimpleTimePeriod(GanttDemo3.date(1, 0, 2005), GanttDemo3.date(1, 1, 2006))));
        TaskSeriesCollection taskSeriesCollection = new TaskSeriesCollection();
        taskSeriesCollection.add(taskSeries);
        taskSeriesCollection.add(taskSeries2);
        taskSeriesCollection.add(taskSeries3);
        taskSeriesCollection.add(taskSeries4);
        return taskSeriesCollection;
    }

    private static Date date(int n, int n2, int n3) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(n3, n2, n);
        Date date = calendar.getTime();
        return date;
    }

    private static JFreeChart createChart(IntervalCategoryDataset intervalCategoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createGanttChart("Contract Version Validity Demo", "", null, intervalCategoryDataset, false, true, false);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        MyGanttRenderer myGanttRenderer = new MyGanttRenderer();
        categoryPlot.setRenderer(myGanttRenderer);
        categoryPlot.getDomainAxis().setCategoryMargin(0.05);
        categoryPlot.getDomainAxis().setMaximumCategoryLabelWidthRatio(10.0f);
        myGanttRenderer.setDrawBarOutline(false);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = GanttDemo3.createChart(GanttDemo3.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        GanttDemo3 ganttDemo3 = new GanttDemo3("Gantt Chart Demo 3");
        ganttDemo3.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)ganttDemo3));
        ganttDemo3.setVisible(true);
    }

    static class MyGanttRenderer
    extends GanttRenderer2 {
        public Paint getItemPaint(int n, int n2) {
            return DefaultDrawingSupplier.DEFAULT_PAINT_SEQUENCE[n2];
        }

        protected void drawTask(Graphics2D graphics2D, CategoryItemRendererState categoryItemRendererState, Rectangle2D rectangle2D, CategoryPlot categoryPlot, CategoryAxis categoryAxis, ValueAxis valueAxis, GanttCategoryDataset ganttCategoryDataset, int n, int n2) {
            Object object;
            Object object2;
            int n3;
            PlotOrientation plotOrientation = categoryPlot.getOrientation();
            RectangleEdge rectangleEdge = categoryPlot.getRangeAxisEdge();
            Number number = ganttCategoryDataset.getEndValue(n, n2);
            if (number == null) {
                return;
            }
            double d = valueAxis.valueToJava2D(number.doubleValue(), rectangle2D, rectangleEdge);
            Number number2 = ganttCategoryDataset.getStartValue(n, n2);
            if (number2 == null) {
                return;
            }
            double d2 = valueAxis.valueToJava2D(number2.doubleValue(), rectangle2D, rectangleEdge);
            if (d2 < d) {
                double d3 = d2;
                d2 = d;
                d = d3;
                Number number3 = number2;
                number2 = number;
                number = number3;
            }
            if ((n3 = this.countNonNullValues(ganttCategoryDataset, n2)) == 0) {
                return;
            }
            int n4 = this.countPriorNonNullValues(ganttCategoryDataset, n2, n);
            double d4 = (categoryAxis.getCategoryEnd(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) - categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge())) / (double)n3;
            double d5 = categoryAxis.getCategoryStart(n2, this.getColumnCount(), rectangle2D, categoryPlot.getDomainAxisEdge()) + d4 * (double)n4;
            double d6 = Math.abs(d2 - d);
            Rectangle2D.Double double_ = null;
            if (plotOrientation == PlotOrientation.HORIZONTAL) {
                double_ = new Rectangle2D.Double(d, d5, d6, d4);
            } else if (plotOrientation == PlotOrientation.VERTICAL) {
                double_ = new Rectangle2D.Double(d5, d2, d4, d6);
            }
            Rectangle2D.Double double_2 = null;
            Rectangle2D.Double double_3 = null;
            Number number4 = ganttCategoryDataset.getPercentComplete(n, n2);
            double d7 = this.getStartPercent();
            double d8 = this.getEndPercent();
            if (number4 != null) {
                double d9 = number4.doubleValue();
                if (categoryPlot.getOrientation() == PlotOrientation.HORIZONTAL) {
                    double_2 = new Rectangle2D.Double(d, d5 + d7 * d4, d6 * d9, d4 * (d8 - d7));
                    double_3 = new Rectangle2D.Double(d + d6 * d9, d5 + d7 * d4, d6 * (1.0 - d9), d4 * (d8 - d7));
                } else if (categoryPlot.getOrientation() == PlotOrientation.VERTICAL) {
                    double_2 = new Rectangle2D.Double(d5 + d7 * d4, d2 + d6 * (1.0 - d9), d4 * (d8 - d7), d6 * d9);
                    double_3 = new Rectangle2D.Double(d5 + d7 * d4, d2, d4 * (d8 - d7), d6 * (1.0 - d9));
                }
            }
            Paint paint = this.getItemPaint(n, n2);
            graphics2D.setPaint(paint);
            graphics2D.fill(double_);
            if (double_2 != null) {
                graphics2D.setPaint(this.getCompletePaint());
                graphics2D.fill(double_2);
            }
            if (double_3 != null) {
                graphics2D.setPaint(this.getIncompletePaint());
                graphics2D.fill(double_3);
            }
            if (this.isDrawBarOutline() && categoryItemRendererState.getBarWidth() > 3.0) {
                object2 = this.getItemOutlineStroke(n, n2);
                object = this.getItemOutlinePaint(n, n2);
                if (object2 != null && object != null) {
                    graphics2D.setStroke((Stroke)object2);
                    graphics2D.setPaint((Paint)object);
                    graphics2D.draw(double_);
                }
            }
            if ((object2 = this.getItemLabelGenerator(n, n2)) != null && this.isItemLabelVisible(n, n2)) {
                this.drawItemLabel(graphics2D, ganttCategoryDataset, n, n2, categoryPlot, (CategoryItemLabelGenerator)object2, double_, false);
            }
            if (categoryItemRendererState.getInfo() != null && (object = categoryItemRendererState.getEntityCollection()) != null) {
                String string = null;
                CategoryToolTipGenerator categoryToolTipGenerator = this.getToolTipGenerator(n, n2);
                if (categoryToolTipGenerator != null) {
                    string = categoryToolTipGenerator.generateToolTip(ganttCategoryDataset, n, n2);
                }
                String string2 = null;
                if (this.getItemURLGenerator(n, n2) != null) {
                    string2 = this.getItemURLGenerator(n, n2).generateURL(ganttCategoryDataset, n, n2);
                }
                CategoryItemEntity categoryItemEntity = new CategoryItemEntity(double_, string, string2, ganttCategoryDataset, n, ganttCategoryDataset.getColumnKey(n2), n2);
                object.add(categoryItemEntity);
            }
        }

        private int countNonNullValues(CategoryDataset categoryDataset, int n) {
            return this.countPriorNonNullValues(categoryDataset, n, categoryDataset.getRowCount());
        }

        private int countPriorNonNullValues(CategoryDataset categoryDataset, int n, int n2) {
            if (n2 == 0) {
                return 0;
            }
            int n3 = 0;
            for (int i = 0; i < n2; ++i) {
                if (categoryDataset.getValue(i, n) == null) continue;
                ++n3;
            }
            return n3;
        }
    }
}

