/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.renderer.category.IntervalBarRenderer;
import org.jfree.data.category.DefaultIntervalCategoryDataset;
import org.jfree.data.category.IntervalCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class IntervalBarChartDemo1
extends ApplicationFrame {
    public IntervalBarChartDemo1(String string) {
        super(string);
        JPanel jPanel = IntervalBarChartDemo1.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static IntervalCategoryDataset createDataset() {
        double[][] dArrayArray = new double[][]{{0.1, 0.2, 0.3}, {0.3, 0.4, 0.5}};
        double[][] dArrayArray2 = new double[][]{{0.5, 0.6, 0.7}, {0.7, 0.8, 0.9}};
        DefaultIntervalCategoryDataset defaultIntervalCategoryDataset = new DefaultIntervalCategoryDataset(dArrayArray, dArrayArray2);
        return defaultIntervalCategoryDataset;
    }

    private static JFreeChart createChart(IntervalCategoryDataset intervalCategoryDataset) {
        CategoryAxis categoryAxis = new CategoryAxis("Category");
        NumberAxis numberAxis = new NumberAxis("Percentage");
        numberAxis.setNumberFormatOverride(new DecimalFormat("0.00%"));
        IntervalBarRenderer intervalBarRenderer = new IntervalBarRenderer();
        CategoryPlot categoryPlot = new CategoryPlot(intervalCategoryDataset, categoryAxis, numberAxis, intervalBarRenderer);
        JFreeChart jFreeChart = new JFreeChart(categoryPlot);
        jFreeChart.setBackgroundPaint(Color.white);
        categoryPlot.setBackgroundPaint(Color.lightGray);
        categoryPlot.setDomainGridlinePaint(Color.white);
        categoryPlot.setDomainGridlinesVisible(true);
        categoryPlot.setRangeGridlinePaint(Color.white);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = IntervalBarChartDemo1.createChart(IntervalBarChartDemo1.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        IntervalBarChartDemo1 intervalBarChartDemo1 = new IntervalBarChartDemo1("Interval Bar Chart Demo 1");
        ((Window)((Object)intervalBarChartDemo1)).pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)intervalBarChartDemo1));
        ((Window)((Object)intervalBarChartDemo1)).setVisible(true);
    }
}

