/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import java.text.NumberFormat;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.AxisLocation;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.AbstractCategoryItemLabelGenerator;
import org.jfree.chart.labels.CategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class ItemLabelDemo2
extends ApplicationFrame {
    public ItemLabelDemo2(String string) {
        super(string);
        CategoryDataset categoryDataset = ItemLabelDemo2.createDataset();
        JFreeChart jFreeChart = ItemLabelDemo2.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private static CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(100.0, (Comparable)((Object)"S1"), (Comparable)((Object)"C1"));
        defaultCategoryDataset.addValue(44.3, (Comparable)((Object)"S1"), (Comparable)((Object)"C2"));
        defaultCategoryDataset.addValue(93.0, (Comparable)((Object)"S1"), (Comparable)((Object)"C3"));
        defaultCategoryDataset.addValue(80.0, (Comparable)((Object)"S2"), (Comparable)((Object)"C1"));
        defaultCategoryDataset.addValue(75.1, (Comparable)((Object)"S2"), (Comparable)((Object)"C2"));
        defaultCategoryDataset.addValue(15.1, (Comparable)((Object)"S2"), (Comparable)((Object)"C3"));
        return defaultCategoryDataset;
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart("Item Label Demo 2", "Category", "Value", categoryDataset, PlotOrientation.HORIZONTAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        categoryPlot.setBackgroundPaint(Color.lightGray);
        categoryPlot.setDomainGridlinePaint(Color.white);
        categoryPlot.setRangeGridlinePaint(Color.white);
        categoryPlot.setRangeAxisLocation(AxisLocation.BOTTOM_OR_LEFT);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setUpperMargin(0.25);
        CategoryItemRenderer categoryItemRenderer = categoryPlot.getRenderer();
        categoryItemRenderer.setItemLabelsVisible(true);
        categoryItemRenderer.setItemLabelGenerator(new LabelGenerator(null));
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = ItemLabelDemo2.createChart(ItemLabelDemo2.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        ItemLabelDemo2 itemLabelDemo2 = new ItemLabelDemo2("Item Label Demo 2");
        itemLabelDemo2.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)itemLabelDemo2));
        itemLabelDemo2.setVisible(true);
    }

    static class LabelGenerator
    extends AbstractCategoryItemLabelGenerator
    implements CategoryItemLabelGenerator {
        private Integer category;
        private NumberFormat formatter = NumberFormat.getPercentInstance();

        public LabelGenerator(int n) {
            this(new Integer(n));
        }

        public LabelGenerator(Integer n) {
            super("", NumberFormat.getInstance());
            this.category = n;
        }

        public String generateLabel(CategoryDataset categoryDataset, int n, int n2) {
            Number number;
            String string = null;
            double d = 0.0;
            if (this.category != null) {
                number = categoryDataset.getValue(n, this.category);
                d = number.doubleValue();
            } else {
                d = this.calculateSeriesTotal(categoryDataset, n);
            }
            number = categoryDataset.getValue(n, n2);
            if (number != null) {
                double d2 = number.doubleValue();
                string = number.toString() + " (" + this.formatter.format(d2 / d) + ")";
            }
            return string;
        }

        private double calculateSeriesTotal(CategoryDataset categoryDataset, int n) {
            double d = 0.0;
            for (int i = 0; i < categoryDataset.getColumnCount(); ++i) {
                Number number = categoryDataset.getValue(n, i);
                if (number == null) continue;
                d += number.doubleValue();
            }
            return d;
        }
    }
}

