/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleEdge;
import org.jfree.ui.RefineryUtilities;

public class LineChartDemo1
extends ApplicationFrame {
    public LineChartDemo1(String string) {
        super(string);
        JPanel jPanel = LineChartDemo1.createDemoPanel();
        jPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(jPanel);
    }

    private static CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(212.0, (Comparable)((Object)"Classes"), (Comparable)((Object)"JDK 1.0"));
        defaultCategoryDataset.addValue(504.0, (Comparable)((Object)"Classes"), (Comparable)((Object)"JDK 1.1"));
        defaultCategoryDataset.addValue(1520.0, (Comparable)((Object)"Classes"), (Comparable)((Object)"SDK 1.2"));
        defaultCategoryDataset.addValue(1842.0, (Comparable)((Object)"Classes"), (Comparable)((Object)"SDK 1.3"));
        defaultCategoryDataset.addValue(2991.0, (Comparable)((Object)"Classes"), (Comparable)((Object)"SDK 1.4"));
        return defaultCategoryDataset;
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createLineChart("Java Standard Class Library", "Release", "Class Count", categoryDataset, PlotOrientation.VERTICAL, false, true, false);
        jFreeChart.addSubtitle(new TextTitle("Number of Classes By Release"));
        TextTitle textTitle = new TextTitle("Source: Java In A Nutshell (4th Edition) by David Flanagan (O'Reilly)");
        textTitle.setFont(new Font("SansSerif", 0, 10));
        textTitle.setPosition(RectangleEdge.BOTTOM);
        textTitle.setHorizontalAlignment(HorizontalAlignment.RIGHT);
        jFreeChart.addSubtitle(textTitle);
        jFreeChart.setBackgroundPaint(Color.white);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setBackgroundPaint(Color.lightGray);
        categoryPlot.setRangeGridlinePaint(Color.white);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        LineAndShapeRenderer lineAndShapeRenderer = (LineAndShapeRenderer)categoryPlot.getRenderer();
        lineAndShapeRenderer.setShapesVisible(true);
        lineAndShapeRenderer.setDrawOutlines(true);
        lineAndShapeRenderer.setUseFillPaint(true);
        lineAndShapeRenderer.setFillPaint(Color.white);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = LineChartDemo1.createChart(LineChartDemo1.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        LineChartDemo1 lineChartDemo1 = new LineChartDemo1("Line Chart Demo");
        lineChartDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)lineChartDemo1));
        lineChartDemo1.setVisible(true);
    }
}

