/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.text.SimpleDateFormat;
import java.util.TimeZone;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.PeriodAxis;
import org.jfree.chart.axis.PeriodAxisLabelInfo;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimePeriodAnchor;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.RefineryUtilities;

public class PeriodAxisDemo2
extends ApplicationFrame {
    static /* synthetic */ Class class$org$jfree$data$time$Day;
    static /* synthetic */ Class class$org$jfree$data$time$Month;
    static /* synthetic */ Class class$org$jfree$data$time$Year;

    public PeriodAxisDemo2(String string) {
        super(string);
        XYDataset xYDataset = PeriodAxisDemo2.createDataset();
        JFreeChart jFreeChart = PeriodAxisDemo2.createChart(xYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        chartPanel.setMouseZoomable(true, false);
        this.setContentPane(chartPanel);
    }

    private static JFreeChart createChart(XYDataset xYDataset) {
        Cloneable cloneable;
        JFreeChart jFreeChart = ChartFactory.createTimeSeriesChart("Legal & General Unit Trust Prices", "Date", "Price Per Unit", xYDataset, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        XYPlot xYPlot = (XYPlot)jFreeChart.getPlot();
        xYPlot.setBackgroundPaint(Color.lightGray);
        xYPlot.setDomainGridlinePaint(Color.white);
        xYPlot.setRangeGridlinePaint(Color.white);
        xYPlot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        xYPlot.setDomainCrosshairVisible(true);
        xYPlot.setRangeCrosshairVisible(true);
        XYItemRenderer xYItemRenderer = xYPlot.getRenderer();
        if (xYItemRenderer instanceof XYLineAndShapeRenderer) {
            cloneable = (XYLineAndShapeRenderer)xYItemRenderer;
            ((XYLineAndShapeRenderer)cloneable).setShapesVisible(true);
            ((XYLineAndShapeRenderer)cloneable).setShapesFilled(true);
            ((AbstractRenderer)cloneable).setItemLabelsVisible(true);
        }
        cloneable = new PeriodAxis("Date");
        ((PeriodAxis)cloneable).setTimeZone(TimeZone.getTimeZone("Pacific/Auckland"));
        ((PeriodAxis)cloneable).setAutoRangeTimePeriodClass(class$org$jfree$data$time$Day == null ? (class$org$jfree$data$time$Day = PeriodAxisDemo2.class$("org.jfree.data.time.Day")) : class$org$jfree$data$time$Day);
        PeriodAxisLabelInfo[] periodAxisLabelInfoArray = new PeriodAxisLabelInfo[]{new PeriodAxisLabelInfo(class$org$jfree$data$time$Day == null ? (class$org$jfree$data$time$Day = PeriodAxisDemo2.class$("org.jfree.data.time.Day")) : class$org$jfree$data$time$Day, new SimpleDateFormat("d")), new PeriodAxisLabelInfo(class$org$jfree$data$time$Month == null ? (class$org$jfree$data$time$Month = PeriodAxisDemo2.class$("org.jfree.data.time.Month")) : class$org$jfree$data$time$Month, new SimpleDateFormat("MMM"), new RectangleInsets(2.0, 2.0, 2.0, 2.0), new Font("SansSerif", 1, 10), Color.blue, false, new BasicStroke(0.0f), Color.lightGray), new PeriodAxisLabelInfo(class$org$jfree$data$time$Year == null ? (class$org$jfree$data$time$Year = PeriodAxisDemo2.class$("org.jfree.data.time.Year")) : class$org$jfree$data$time$Year, new SimpleDateFormat("yyyy"))};
        ((PeriodAxis)cloneable).setLabelInfo(periodAxisLabelInfoArray);
        xYPlot.setDomainAxis((ValueAxis)cloneable);
        return jFreeChart;
    }

    private static XYDataset createDataset() {
        TimeSeries timeSeries = new TimeSeries("L&G European Index Trust");
        timeSeries.add((RegularTimePeriod)new Day(24, 1, 2004), 181.8);
        timeSeries.add((RegularTimePeriod)new Day(25, 1, 2004), 167.3);
        timeSeries.add((RegularTimePeriod)new Day(26, 1, 2004), 153.8);
        timeSeries.add((RegularTimePeriod)new Day(27, 1, 2004), 167.6);
        timeSeries.add((RegularTimePeriod)new Day(28, 1, 2004), 158.8);
        timeSeries.add((RegularTimePeriod)new Day(29, 1, 2004), 148.3);
        timeSeries.add((RegularTimePeriod)new Day(30, 1, 2004), 153.9);
        timeSeries.add((RegularTimePeriod)new Day(31, 1, 2004), 142.7);
        timeSeries.add((RegularTimePeriod)new Day(1, 2, 2004), 123.2);
        timeSeries.add((RegularTimePeriod)new Day(2, 2, 2004), 131.8);
        timeSeries.add((RegularTimePeriod)new Day(3, 2, 2004), 139.6);
        timeSeries.add((RegularTimePeriod)new Day(4, 2, 2004), 142.9);
        timeSeries.add((RegularTimePeriod)new Day(5, 2, 2004), 138.7);
        timeSeries.add((RegularTimePeriod)new Day(6, 2, 2004), 137.3);
        timeSeries.add((RegularTimePeriod)new Day(7, 2, 2004), 143.9);
        timeSeries.add((RegularTimePeriod)new Day(8, 2, 2004), 139.8);
        timeSeries.add((RegularTimePeriod)new Day(9, 2, 2004), 137.0);
        timeSeries.add((RegularTimePeriod)new Day(10, 2, 2004), 132.8);
        TimeZone timeZone = TimeZone.getTimeZone("Pacific/Auckland");
        TimeSeriesCollection timeSeriesCollection = new TimeSeriesCollection(timeZone);
        timeSeriesCollection.addSeries(timeSeries);
        timeSeriesCollection.setDomainIsPointsInTime(true);
        timeSeriesCollection.setXPosition(TimePeriodAnchor.MIDDLE);
        return timeSeriesCollection;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = PeriodAxisDemo2.createChart(PeriodAxisDemo2.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        PeriodAxisDemo2 periodAxisDemo2 = new PeriodAxisDemo2("Period Axis Demo 2");
        periodAxisDemo2.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)periodAxisDemo2));
        periodAxisDemo2.setVisible(true);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

