/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class StackedBarChart3DDemo
extends ApplicationFrame {
    public StackedBarChart3DDemo(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    public CategoryDataset createDataset() {
        double[][] dArrayArray = new double[][]{{10.0, 4.0, 15.0, 14.0}, {-5.0, -7.0, 14.0, -3.0}, {6.0, 17.0, -12.0, 7.0}, {7.0, 15.0, 11.0, 0.0}, {-8.0, -6.0, 10.0, -9.0}, {9.0, 8.0, 0.0, 6.0}, {-10.0, 9.0, 7.0, 7.0}, {11.0, 13.0, 9.0, 9.0}, {-3.0, 7.0, 11.0, -10.0}};
        return DatasetUtilities.createCategoryDataset("Series ", "Category ", (double[][])dArrayArray);
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createStackedBarChart3D("Stacked Bar Chart 3D Demo", "Category", "Value", categoryDataset, PlotOrientation.HORIZONTAL, true, true, false);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        barRenderer.setDrawBarOutline(false);
        barRenderer.setItemLabelGenerator(new StandardCategoryItemLabelGenerator());
        barRenderer.setItemLabelsVisible(true);
        barRenderer.setPositiveItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        barRenderer.setNegativeItemLabelPosition(new ItemLabelPosition(ItemLabelAnchor.CENTER, TextAnchor.CENTER));
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        StackedBarChart3DDemo stackedBarChart3DDemo = new StackedBarChart3DDemo("Stacked Bar Chart 3D Demo");
        stackedBarChart3DDemo.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)stackedBarChart3DDemo));
        stackedBarChart3DDemo.setVisible(true);
    }
}

