/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class StackedXYBarChartDemo1
extends ApplicationFrame {
    public StackedXYBarChartDemo1(String string) {
        super(string);
        TableXYDataset tableXYDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(tableXYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private TableXYDataset createDataset() {
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        XYSeries xYSeries = new XYSeries((Comparable)((Object)"Series 1"), true, false);
        xYSeries.add(1.0, 5.0);
        xYSeries.add(2.0, 15.5);
        xYSeries.add(3.0, 9.5);
        xYSeries.add(4.0, 7.5);
        defaultTableXYDataset.addSeries(xYSeries);
        XYSeries xYSeries2 = new XYSeries((Comparable)((Object)"Series 2"), true, false);
        xYSeries2.add(1.0, 5.0);
        xYSeries2.add(2.0, 15.5);
        xYSeries2.add(3.0, 9.5);
        xYSeries2.add(4.0, 3.5);
        defaultTableXYDataset.addSeries(xYSeries2);
        return defaultTableXYDataset;
    }

    private JFreeChart createChart(TableXYDataset tableXYDataset) {
        NumberAxis numberAxis = new NumberAxis("X");
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        NumberAxis numberAxis2 = new NumberAxis("Y");
        StackedXYBarRenderer stackedXYBarRenderer = new StackedXYBarRenderer(0.1);
        stackedXYBarRenderer.setDrawBarOutline(false);
        XYPlot xYPlot = new XYPlot(tableXYDataset, numberAxis, numberAxis2, stackedXYBarRenderer);
        JFreeChart jFreeChart = new JFreeChart("Stacked XY Bar Chart Demo 1", xYPlot);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        StackedXYBarChartDemo1 stackedXYBarChartDemo1 = new StackedXYBarChartDemo1("Stacked XY Bar Chart Demo 1");
        stackedXYBarChartDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)stackedXYBarChartDemo1));
        stackedXYBarChartDemo1.setVisible(true);
    }
}

