/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Dimension;
import java.awt.Window;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.DateTickMarkPosition;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYBarRenderer;
import org.jfree.data.time.Day;
import org.jfree.data.time.TimeTableXYDataset;
import org.jfree.data.xy.TableXYDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class StackedXYBarChartDemo2
extends ApplicationFrame {
    public StackedXYBarChartDemo2(String string) {
        super(string);
        TableXYDataset tableXYDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(tableXYDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private TableXYDataset createDataset() {
        TimeTableXYDataset timeTableXYDataset = new TimeTableXYDataset();
        Day day = new Day(1, 3, 2005);
        Day day2 = new Day(2, 3, 2005);
        Day day3 = new Day(3, 3, 2005);
        Day day4 = new Day(4, 3, 2005);
        Day day5 = new Day(5, 3, 2005);
        timeTableXYDataset.add(day, 1.0, "Series 1");
        timeTableXYDataset.add(day2, 1.7, "Series 1");
        timeTableXYDataset.add(day3, 2.3, "Series 1");
        timeTableXYDataset.add(day4, 3.7, "Series 1");
        timeTableXYDataset.add(day5, 2.6, "Series 1");
        timeTableXYDataset.add(day, 3.2, "Series 2");
        timeTableXYDataset.add(day2, 1.1, "Series 2");
        timeTableXYDataset.add(day3, 1.4, "Series 2");
        timeTableXYDataset.add(day4, 2.9, "Series 2");
        timeTableXYDataset.add(day5, 0.6, "Series 2");
        return timeTableXYDataset;
    }

    private JFreeChart createChart(TableXYDataset tableXYDataset) {
        DateAxis dateAxis = new DateAxis("Date");
        dateAxis.setTickMarkPosition(DateTickMarkPosition.MIDDLE);
        NumberAxis numberAxis = new NumberAxis("Y");
        StackedXYBarRenderer stackedXYBarRenderer = new StackedXYBarRenderer(0.1);
        stackedXYBarRenderer.setDrawBarOutline(false);
        XYPlot xYPlot = new XYPlot(tableXYDataset, dateAxis, numberAxis, stackedXYBarRenderer);
        JFreeChart jFreeChart = new JFreeChart("Stacked XY Bar Chart Demo 2", xYPlot);
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        StackedXYBarChartDemo2 stackedXYBarChartDemo2 = new StackedXYBarChartDemo2("Stacked XY Bar Chart Demo 2");
        stackedXYBarChartDemo2.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)stackedXYBarChartDemo2));
        stackedXYBarChartDemo2.setVisible(true);
    }
}

