/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Window;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.StatisticalBarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.statistics.DefaultStatisticalCategoryDataset;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.RefineryUtilities;

public class StatisticalBarChartDemo1
extends ApplicationFrame {
    public StatisticalBarChartDemo1(String string) {
        super(string);
        CategoryDataset categoryDataset = StatisticalBarChartDemo1.createDataset();
        JFreeChart jFreeChart = StatisticalBarChartDemo1.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(500, 270));
        this.setContentPane(chartPanel);
    }

    private static CategoryDataset createDataset() {
        DefaultStatisticalCategoryDataset defaultStatisticalCategoryDataset = new DefaultStatisticalCategoryDataset();
        defaultStatisticalCategoryDataset.add(10.0, 2.4, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 1"));
        defaultStatisticalCategoryDataset.add(15.0, 4.4, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 2"));
        defaultStatisticalCategoryDataset.add(13.0, 2.1, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 3"));
        defaultStatisticalCategoryDataset.add(7.0, 1.3, (Comparable)((Object)"Row 1"), (Comparable)((Object)"Column 4"));
        defaultStatisticalCategoryDataset.add(22.0, 2.4, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 1"));
        defaultStatisticalCategoryDataset.add(18.0, 4.4, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 2"));
        defaultStatisticalCategoryDataset.add(28.0, 2.1, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 3"));
        defaultStatisticalCategoryDataset.add(17.0, 1.3, (Comparable)((Object)"Row 2"), (Comparable)((Object)"Column 4"));
        return defaultStatisticalCategoryDataset;
    }

    private static JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createLineChart("Statistical Bar Chart Demo 1", "Type", "Value", categoryDataset, PlotOrientation.VERTICAL, true, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        CategoryPlot categoryPlot = (CategoryPlot)jFreeChart.getPlot();
        categoryPlot.setBackgroundPaint(Color.lightGray);
        categoryPlot.setRangeGridlinePaint(Color.white);
        NumberAxis numberAxis = (NumberAxis)categoryPlot.getRangeAxis();
        numberAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberAxis.setAutoRangeIncludesZero(true);
        StatisticalBarRenderer statisticalBarRenderer = new StatisticalBarRenderer();
        statisticalBarRenderer.setErrorIndicatorPaint(Color.black);
        categoryPlot.setRenderer(statisticalBarRenderer);
        return jFreeChart;
    }

    public static JPanel createDemoPanel() {
        JFreeChart jFreeChart = StatisticalBarChartDemo1.createChart(StatisticalBarChartDemo1.createDataset());
        return new ChartPanel(jFreeChart);
    }

    public static void main(String[] stringArray) {
        StatisticalBarChartDemo1 statisticalBarChartDemo1 = new StatisticalBarChartDemo1("Statistical Bar Chart Demo");
        statisticalBarChartDemo1.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)statisticalBarChartDemo1));
        statisticalBarChartDemo1.setVisible(true);
    }
}

