/*
 * Decompiled with CFR 0.152.
 */
package demo;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Window;
import java.text.DecimalFormat;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryLabelPosition;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.ExtendedCategoryAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.ItemLabelAnchor;
import org.jfree.chart.labels.ItemLabelPosition;
import org.jfree.chart.labels.StandardCategoryItemLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.text.TextBlockAnchor;
import org.jfree.ui.ApplicationFrame;
import org.jfree.ui.HorizontalAlignment;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RefineryUtilities;
import org.jfree.ui.TextAnchor;

public class SurveyResultsDemo3
extends ApplicationFrame {
    public SurveyResultsDemo3(String string) {
        super(string);
        CategoryDataset categoryDataset = this.createDataset();
        JFreeChart jFreeChart = this.createChart(categoryDataset);
        ChartPanel chartPanel = new ChartPanel(jFreeChart);
        chartPanel.setPreferredSize(new Dimension(300, 270));
        this.setContentPane(chartPanel);
    }

    private CategoryDataset createDataset() {
        DefaultCategoryDataset defaultCategoryDataset = new DefaultCategoryDataset();
        defaultCategoryDataset.addValue(2.61, (Comparable)((Object)"Results"), (Comparable)((Object)"Sm."));
        defaultCategoryDataset.addValue(2.7, (Comparable)((Object)"Results"), (Comparable)((Object)"Med."));
        defaultCategoryDataset.addValue(2.9, (Comparable)((Object)"Results"), (Comparable)((Object)"Lg."));
        defaultCategoryDataset.addValue(2.74, (Comparable)((Object)"Results"), (Comparable)((Object)"All"));
        return defaultCategoryDataset;
    }

    private JFreeChart createChart(CategoryDataset categoryDataset) {
        JFreeChart jFreeChart = ChartFactory.createBarChart(null, null, null, categoryDataset, PlotOrientation.HORIZONTAL, false, true, false);
        jFreeChart.setBackgroundPaint(Color.white);
        jFreeChart.getPlot().setOutlinePaint(null);
        TextTitle textTitle = new TextTitle("Figure 6 | Overall SEO Rating");
        textTitle.setHorizontalAlignment(HorizontalAlignment.LEFT);
        textTitle.setBackgroundPaint(Color.red);
        textTitle.setPaint(Color.white);
        jFreeChart.setTitle(textTitle);
        CategoryPlot categoryPlot = jFreeChart.getCategoryPlot();
        ValueAxis valueAxis = categoryPlot.getRangeAxis();
        valueAxis.setRange(0.0, 4.0);
        valueAxis.setVisible(false);
        ExtendedCategoryAxis extendedCategoryAxis = new ExtendedCategoryAxis(null);
        extendedCategoryAxis.setTickLabelFont(new Font("SansSerif", 1, 12));
        extendedCategoryAxis.setCategoryMargin(0.3);
        extendedCategoryAxis.addSubLabel((Comparable)((Object)"Sm."), "(10)");
        extendedCategoryAxis.addSubLabel((Comparable)((Object)"Med."), "(10)");
        extendedCategoryAxis.addSubLabel((Comparable)((Object)"Lg."), "(10)");
        extendedCategoryAxis.addSubLabel((Comparable)((Object)"All"), "(10)");
        CategoryLabelPositions categoryLabelPositions = extendedCategoryAxis.getCategoryLabelPositions();
        CategoryLabelPosition categoryLabelPosition = new CategoryLabelPosition(RectangleAnchor.LEFT, TextBlockAnchor.CENTER_LEFT);
        extendedCategoryAxis.setCategoryLabelPositions(CategoryLabelPositions.replaceLeftPosition(categoryLabelPositions, categoryLabelPosition));
        categoryPlot.setDomainAxis(extendedCategoryAxis);
        BarRenderer barRenderer = (BarRenderer)categoryPlot.getRenderer();
        barRenderer.setSeriesPaint(0, new Color(156, 164, 74));
        barRenderer.setBaseOutlineStroke(null);
        StandardCategoryItemLabelGenerator standardCategoryItemLabelGenerator = new StandardCategoryItemLabelGenerator("{2}", new DecimalFormat("0.00"));
        barRenderer.setItemLabelGenerator(standardCategoryItemLabelGenerator);
        barRenderer.setItemLabelsVisible(true);
        barRenderer.setItemLabelFont(new Font("SansSerif", 0, 18));
        ItemLabelPosition itemLabelPosition = new ItemLabelPosition(ItemLabelAnchor.INSIDE3, TextAnchor.CENTER_RIGHT);
        barRenderer.setPositiveItemLabelPosition(itemLabelPosition);
        barRenderer.setPositiveItemLabelPositionFallback(new ItemLabelPosition());
        return jFreeChart;
    }

    public static void main(String[] stringArray) {
        SurveyResultsDemo3 surveyResultsDemo3 = new SurveyResultsDemo3("Survey Results Demo 3");
        surveyResultsDemo3.pack();
        RefineryUtilities.centerFrameOnScreen((Window)((Object)surveyResultsDemo3));
        surveyResultsDemo3.setVisible(true);
    }
}

